﻿using gov.va.med.vbecs.Common;
using System;
using System.Runtime.InteropServices;
using System.Windows.Controls;
using System.Windows.Input;
using gov.va.med.vbecs.GUI.controls;
using System.Text.RegularExpressions;

namespace WPF.PresentationLayer.Controls
{
    /// <summary>
    /// WPFBarcodeTextbox
    /// </summary>
    public class WPFBarcodeTextbox : TextBox
    {
        /// <summary>
        /// OnTextChanged, used to filter out alpha numeric characters
        /// </summary>
        /// <param name="e"></param>
        protected override void OnTextChanged(TextChangedEventArgs e)
        {
            var cursorPosition = SelectionStart;
            base.OnTextChanged(e);            
            // Don't allow non alfa numeric characters
            Text = Regex.Replace(Text, "[^0-9a-zA-Z ]", "");
            SelectionStart = cursorPosition;
        }
    }
}
